<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" encoding="UTF-8"/>

<xsl:template match="/">
	<xsl:apply-templates/>
</xsl:template> 

<xsl:template match="alfatech">
<HTML>
	<HEAD>
		<TITLE>
			<xsl:value-of select="./@title"/>
		</TITLE>
	</HEAD>
	<BODY>
		<xsl:apply-templates select="application"/>
	</BODY>
</HTML>
</xsl:template>

<xsl:template match="application">
	<h1><xsl:value-of select="./@title"/></h1>
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="prefernce">
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="section">
	<h2><xsl:value-of select="./@title"/></h2>
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="section/*">
	<xsl:value-of select="./@title"/>
	<table border="2" cellpadding="2" cellspacing="0">
	<xsl:apply-templates/>
	</table>
	<br/>
	<br/>
</xsl:template>

<xsl:template match="data">
	<xsl:variable name="presection" select="count(../../data)"/>
	<xsl:choose>
		<xsl:when test="$presection = 0">
			<xsl:text disable-output-escaping="yes">&lt;tr valign="top"&gt;</xsl:text>
			<td>
				<xsl:attribute name="rowspan">
					<xsl:value-of select="count(descendant::value)"/>
				</xsl:attribute>
				<xsl:value-of select="@title"/>
			</td>
		</xsl:when>
		<xsl:when test="position() > 1">
			<xsl:text disable-output-escaping="yes">&lt;tr valign="top"&gt;</xsl:text>
			<td>
				<xsl:attribute name="rowspan">
					<xsl:value-of select="count(descendant::value)"/>
				</xsl:attribute>
			<xsl:value-of select="@title"/>
			</td>
		</xsl:when>
		<xsl:otherwise>
			<td>
				<xsl:attribute name="rowspan">
					<xsl:value-of select="count(descendant::value)"/>
				</xsl:attribute>
			<xsl:value-of select="@title"/>
			</td>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="value">
	<xsl:if test="position() > 1">
		<xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text>
	</xsl:if>
	<xsl:if test="@title!=''">
		<td>
			<xsl:value-of select="@title"/>
		</td>
	</xsl:if>
	<td>
		<xsl:value-of select="."/>
	</td>
	<xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>
</xsl:template>

</xsl:stylesheet>
